VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   6615
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   8205
   LinkTopic       =   "Form1"
   ScaleHeight     =   6615
   ScaleWidth      =   8205
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Cairo As New cCairo

Private Sub Form_Load()
  Caption = "Click Me!"
End Sub

Private Sub Form_Click()

  Dim Srf As cCairoSurface
  'now we allocate a Surface, which matches with our Forms initial Client-Area
  Me.ScaleMode = vbPixels
  Set Srf = Cairo.CreateSurface(Me.ScaleWidth, Me.ScaleHeight, ImageSurface)
  
  
  Dim CC As cCairoContext
  Set CC = Srf.CreateContext
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  
  'Cairo supports different "Line-EndPoints" (LineCaps), as well as different
  'LineJoins - the initial LineWidth in a new created CC is 2.
  'But let's draw our first line
  CC.TranslateDrawings 15, 15
  CC.SetSourceColor vbGreen
  DrawLineOn CC
  
  'Now some "heavy lines", to make the different End-Points more obvious
  CC.TranslateDrawings 50, 0 'since we do not wrap the CC with Save/Restore, the Transforms will "add up"
  CC.SetSourceColor vbGreen
  CC.SetLineWidth 15
  CC.SetLineCap CAIRO_LINE_CAP_BUTT 'this is also the default on an initial CC
  DrawLineOn CC
  
  
  CC.TranslateDrawings 50, 0 'since we do not wrap the CC with Save/Restore, the Transforms will "add up"
  CC.SetSourceColor vbGreen
  CC.SetLineWidth 15
  CC.SetLineCap CAIRO_LINE_CAP_SQUARE
  DrawLineOn CC

  
  CC.TranslateDrawings 50, 0 'since we do not wrap the CC with Save/Restore, the Transforms will "add up"
  CC.SetSourceColor vbGreen
  CC.SetLineWidth 15
  CC.SetLineCap CAIRO_LINE_CAP_ROUND
  DrawLineOn CC

  
  'Ok, after the different Line-Caps, now the Line-Joins - wich are interesting for
  'your "construction" of more complex "Object-Shapes"
  CC.MatrixResetToIdentity 'just set our current transforms to its default (prior holding our "added-up translates")
  CC.TranslateDrawings 25, 170
  CC.SetSourceColor vbBlue
  CC.SetLineJoin CAIRO_LINE_JOIN_MITER 'this is the default
  DrawShapeOn CC
  
  CC.TranslateDrawings 170, 0
  CC.SetSourceColor vbBlue
  CC.SetLineJoin CAIRO_LINE_JOIN_BEVEL
  DrawShapeOn CC

  CC.TranslateDrawings 170, 0
  CC.SetSourceColor vbBlue
  CC.SetLineJoin CAIRO_LINE_JOIN_ROUND
  DrawShapeOn CC
  
  
  'Finally a Demo for the MiterLimit-Setting, which takes effect on
  'Cairos Default-Setting: CAIRO_LINE_JOIN_MITER
  'Here comes the shape again, this time always with CAIRO_LINE_JOIN_MITER,
  'but with different Miter-Limits
  CC.MatrixResetToIdentity
  CC.TranslateDrawings 25, 300
  CC.SetLineWidth 4
  CC.SetSourceColor vbCyan
  
  CC.SetLineCap CAIRO_LINE_CAP_BUTT
  CC.SetLineJoin CAIRO_LINE_JOIN_MITER 'set this back to the cairo-default
  CC.SetMiterLimit 10 'this is the cairo-default on a new CC
  DrawArrowLinesOn CC
  
  CC.TranslateDrawings 170, 0
  CC.SetSourceColor vbCyan
  CC.SetMiterLimit 6 'a value of 6 is already small enough, to change the miter to a bevel
  DrawArrowLinesOn CC

  Srf.DrawToDC hDC
End Sub


Private Sub DrawLineOn(CC As cCairoContext)
  CC.DrawLine 0, 0, 100, 100 'again, also this is only a Path
  CC.Stroke 'the Stroke-Command "paints" *on* (along) the defined Path
            '(not within, as the Fill-Command does)
  
  'since we draw always the same line (only with some offsets)
  'lets visualize again, where the real line-endpoints were -
  'and how the different "Line-Out-Options" of Cairo take effect.
  'Again done with our transparent Circle exactly at the current Line-Endpoints
  CC.SetSourceColor vbRed, 0.3
  CC.Arc 0, 0, 7.5
  CC.Fill
  CC.Arc 100, 100, 7.5
  CC.Fill
End Sub


'this draws a simple triangle
Private Sub DrawShapeOn(CC As cCairoContext)
  CC.MoveTo 0, 0
  CC.RelLineTo 100, 0 'a (relative) Line, 100 units to the right...
  CC.RelLineTo -50, 50 'a (relative) Line, 50 units left and 50 units down...
  CC.ClosePath 'and the last line of our triangle (implicitely) back to our original Point (0,0)
  
  CC.Stroke 'the Stroke-Command "paints" *on* (along) the defined Path
            '(not within, as the Fill-Command does)
  
  'again with our transparent Circle exactly at the current Line-Endpoints
  CC.SetSourceColor vbRed, 0.3
  CC.Arc 0, 0, 7.5
  CC.Fill
  CC.Arc 100, 0, 7.5
  CC.Fill
  CC.Arc 50, 50, 7.5
  CC.Fill
End Sub


'this draws a simple Arrow-Head with a non-closed path at its end
Private Sub DrawArrowLinesOn(CC As cCairoContext)
  CC.MoveTo 0, 0
  CC.RelLineTo 100, 15 'a (relative) Line, 100 units to the right, 15 units down...
  CC.RelLineTo -100, 15 '...and the same "way back"

  CC.Stroke 'the Stroke-Command "paints" *on* (along) the defined Path
            '(not within, as the Fill-Command does)
  
  'again with our transparent Circle exactly at the current Line-Endpoints
  CC.SetSourceColor vbRed, 0.3
  CC.Arc 0, 0, 7.5
  CC.Fill
  CC.Arc 100, 15, 7.5
  CC.Fill
  CC.Arc 0, 30, 7.5
  CC.Fill
End Sub

